<?php
/*--------------------------------------------------------------------
 PriceBuilderInterface.php 2020-2-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Unit\Builders\Interfaces;

use Gambio\Shop\SellingUnit\Unit\Builders\Exceptions\UnfinishedBuildException;
use Gambio\Shop\SellingUnit\Unit\Entities\Price;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\PriceFormatted;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\PricePlain;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\PriceStatus;

/**
 * Interface PriceBuilderInterface
 * @package Gambio\Shop\SellingUnit\Unit\Builders\Interfaces
 */
interface PriceBuilderInterface
{
    /**
     * @return self
     */
    public static function create(): self;
    
    
    /**
     * @return Price
     * @throws UnfinishedBuildException
     */
    public function build(): Price;
    
    
    /**
     * @return PriceBuilderInterface
     */
    public function reset(): PriceBuilderInterface;
    
    
    /**
     * @param PricePlain $plain
     *
     * @return PriceBuilderInterface
     */
    public function withPricePlain(PricePlain $plain): PriceBuilderInterface;
    
    
    /**
     * @param PriceFormatted $formatted
     *
     * @return PriceBuilderInterface
     */
    public function withPriceFormatted(PriceFormatted $formatted): PriceBuilderInterface;

    /**
     * @param PriceStatus $status
     * @return PriceBuilderInterface
     */
    public function withStatus(PriceStatus $status): PriceBuilderInterface;
}